#!/bin/sh
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1998,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#------------------------------------------------------------------------------
# @(#)37	1.7	src/rsct/ffdc/bin/fcinitstk.sh, ffdc, rsct_rzauh, rzauhbase 9/15/00 09:53:26
#------------------------------------------------------------------------------
#
# Module Name:	fcinitstk.sh
#
# Component:	ffdc
#
# Description:	First Failure Data Capture (FFDC) command line interface to the
#		fc_init() API function.  Intended for use from Bourne and
#		Korn Shells.  Used to createa new FFDC Environment or inherit
#		an existing FFDC Environment.
#
# Notes:	Uses the binary file fcistm to carry out its intended
#		function.  fcistm handles all parameter verification, and
#		calculates the values needed to be set in the process environ-
#		ment to establish the FFDC Environment.  These values are
#		passed back to this script through standard output, which this
#		script captures.  This script then issues "export" commands
#		to modify the process environment to establish the FFDC
#		environment.
#
#		fcismd is used to display NLS cataloged messages for this script
#		in cases where the fcistm cannot generate meaningful output.
#
# Exit Status:	The exit status from fcistm is passed to the caller as the
#		exit status of this command.  This script manually sets an
#		exit status of 39 (FC_NOT_SOURCED) if it detects that the
#		script was not "sourced" from its parent script.
#
#------------------------------------------------------------------------------

script_procid=$$
script_fullname=$0
script_basename=`basename $0`

# Make a basic check to see if this script is being "sourced" from its parent.
# Unless the script is "sourced", the environment modifications it makes will
# not be assumed by the calling script. Check this by examining $0 of this
# script, and see if it matches the script's own name.  If it does match, then
# the script assumes that it wasn't sourced.
if test "$script_basename" = "fcinit.sh"
then
	/usr/sbin/rsct/bin/fcismd 3
	exit 39
fi

# Execute the fcistm command and capture its standard output (let any
# standard error go to wherever standard error is currently directed).  If
# the exit status from the command indicates a problem, halt processing.

fcinitstk_out=`/usr/sbin/rsct/bin/fcistm -n$script_procid -p$script_fullname $*`
rc=$?

# An exit status of 2 indicates that a help message was generated.  Display
# the help message and exit.
if test $rc -eq 2
then
	/usr/sbin/rsct/bin/fcismd 1
	/usr/sbin/rsct/bin/fcismd 2
	return $rc
fi

# Any exit status other than 0 (FFDC Environment created) or 1 (FFDC Environment
# inherited) indicates a failure, and fcistm should not have generated any
# information to standard output.  Error messages were sent to standard error.
# Pass along the exit status and stop.
if test $rc -ne 0
then
	if test $rc -ne 1
	then
		return $rc
	fi
fi

# When an FFDC Environment can be created or inherited, fcistm has sent back
# the environment variables to be set in standard output.  Parse this list and
# issue the "export" command on each element to set the process environment.
for env_var in $fcinitstk_out
do
	export $env_var
done

# Pass along the exit status of fcistm to indicate whether the environment
# was created or inherited
return $rc
